%function [x_axis,y_axis,z_axis] = get_Vg_vs_B
%% set the default font size for all figure
set(0,'defaultAxesFontSize',20)

%% ask the user to load the file
uiwait(msgbox('Choose the file you want to analyze'))
[fileName,pathName,~] = uigetfile('*.dat', 'Open file .dat');

%% get the data by reading the file
file = importdata(fullfile(pathName,fileName));

%% ask for the gate voltage 1 amplification
prompt_dac5 = 'enter the amplification for dac5 in Volts';
dlgtitle_dac5 = 'Input';
user_val_dac5 = inputdlg(prompt_dac5,dlgtitle_dac5);
dac5_val = str2num(user_val_dac5{1});

%% ask for the gate voltage 2 amplification
prompt_dac10 = 'enter the amplification for dac10 in Volts';
dlgtitle_dac10 = 'Input';
user_val_dac10 = inputdlg(prompt_dac10,dlgtitle_dac10);
dac10_val = str2num(user_val_dac10{1});

%% ask for the input lockin amplification
prompt_Vac = 'enter lockin amplification in Volts';
dlgtitle_Vac = 'Input';
user_val_Vac = inputdlg(prompt_Vac,dlgtitle_Vac);
Vac_val = str2num(user_val_Vac{1});

%% ask for the measured currect (lockinX) amplification
prompt_Imeas = 'enter the amplification for measured lockin current in Amps';
dlgtitle_Imeas = 'Input';
user_val_Imeas = inputdlg(prompt_Imeas,dlgtitle_Imeas);
Imeas_val = str2num(user_val_Imeas{1});

%% Reading the size of dac5 
str_dac5 = char(file.textdata(6));
str_split_dac5 = strsplit(str_dac5);
size_dac5 = str2num(str_split_dac5{3});

%% Getting dac5 values
dac5 = file.data(1:size_dac5,1)*dac5_val;

%% Reading the size of dac10 
str_dac10 = char(file.textdata(12));
str_split_dac10 = strsplit(str_dac10);
size_dac10 = str2num(str_split_dac10{3});

%% Getting dac10 values
r=1;
for i=1:size_dac10
    dac10(i) = file.data(r,2)*dac10_val;
    r=r+size_dac5;
end

%% Getting measured current (lockinX) values
s=1;
Imeasure = zeros(size_dac10,size_dac5);
for i=1:size_dac10
    Imeasure(i,1:size_dac5)=file.data(s:s+size_dac5-1,6)*Imeas_val;
    s=s+size_dac5;
end

%% calculating the differential conductance in SI units
dIdV = Imeasure/Vac_val;

figure;
x_axis = transpose(dac5)*1000; %in mV
y_axis = transpose(dac10)*1000; %in mV
z_axis = dIdV;
[X,Y] = meshgrid(x_axis,y_axis);
figure1 = pcolor(X,Y,dIdV);
hold on
set(figure1, 'EdgeColor', 'none');
cl=colorbar;
% max_value = max(max(transpose(dIdV(:,2:end-1))));
% caxis([0 max_value])
% caxis([0 2*10^4])
cl.Label.String = 'G (S)';
xlabel('$V_{g1}(mV)$','Interpreter','latex');
ylabel('$V_{g2}(mV)$','Interpreter','latex');

%end